/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.client.gui;

import com.agricraft.agricraft.api.AgriApi;
import com.agricraft.agricraft.api.codecs.AgriSoil;
import com.agricraft.agricraft.api.tools.magnifying.MagnifyingInspectable;
import com.agricraft.agricraft.api.tools.magnifying.MagnifyingInspector;
import com.agricraft.agricraft.common.registry.ModItems;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1922;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_408;

public class MagnifyingGlassOverlay {
    private static final List<Predicate<class_1657>> allowingPredicates = new ArrayList<Predicate<class_1657>>();
    private static final Set<MagnifyingInspector> inspectors = new HashSet<MagnifyingInspector>();
    private static int hoverTicks;

    public static void addAllowingPredicate(Predicate<class_1657> predicate) {
        allowingPredicates.add(predicate);
    }

    public static void addInspector(MagnifyingInspector inspector) {
        inspectors.add(inspector);
    }

    public static void renderOverlay(class_332 graphics, float partialTicks) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1755 != null && !(mc.field_1755 instanceof class_408) || mc.field_1690.field_1842 || mc.field_1761.method_2920() == class_1934.field_9219 || mc.field_1724 == null || mc.field_1687 == null) {
            hoverTicks = 0;
            return;
        }
        boolean shouldOverlay = false;
        for (Predicate<class_1657> predicate : allowingPredicates) {
            if (!predicate.test((class_1657)mc.field_1724)) continue;
            shouldOverlay = true;
            break;
        }
        if (!shouldOverlay) {
            hoverTicks = 0;
            return;
        }
        Optional<MagnifyingInspectable> inspectable = MagnifyingGlassOverlay.inspectors.stream().map(inspectors -> inspectors.inspect((class_1937)mc.field_1687, (class_1657)mc.field_1724, mc.field_1765)).filter(Optional::isPresent).map(Optional::get).findFirst();
        if (inspectable.isEmpty()) {
            hoverTicks = 0;
            return;
        }
        int posX = graphics.method_51421() / 2 + 20;
        int posY = graphics.method_51443() / 2;
        float fade = class_3532.method_15363((float)((float)(++hoverTicks) / 48.0f), (float)0.0f, (float)1.0f);
        posX += (int)(Math.pow(1.0f - fade, 3.0) * 8.0);
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        inspectable.get().addMagnifyingTooltip(tooltip, mc.field_1724.method_5715());
        if (!tooltip.isEmpty()) {
            int tooltipHeight = 8;
            if (tooltip.size() > 1) {
                tooltipHeight += 2;
                tooltipHeight += (tooltip.size() - 1) * 10;
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)class_3532.method_15363((float)((float)hoverTicks / 24.0f), (float)0.0f, (float)0.8f));
            graphics.method_51437(mc.field_1772, tooltip, Optional.empty(), posX - 12, posY - tooltipHeight / 2 + 12);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    static {
        MagnifyingGlassOverlay.addAllowingPredicate(player -> player.method_6047().method_31574((class_1792)ModItems.MAGNIFYING_GLASS.get()));
        MagnifyingGlassOverlay.addAllowingPredicate(player -> player.method_6079().method_31574((class_1792)ModItems.MAGNIFYING_GLASS.get()));
        MagnifyingGlassOverlay.addAllowingPredicate(player -> {
            class_2487 tag = player.method_6118(class_1304.field_6169).method_7969();
            return tag != null && tag.method_10577("magnifying");
        });
        inspectors.add((level, player, hitResult) -> {
            if (hitResult instanceof class_3965) {
                class_3965 result = (class_3965)hitResult;
                class_2586 patt2302$temp = level.method_8321(result.method_17777());
                if (patt2302$temp instanceof MagnifyingInspectable) {
                    MagnifyingInspectable inspectable = (MagnifyingInspectable)patt2302$temp;
                    return Optional.of(inspectable);
                }
                Optional<AgriSoil> soil = AgriApi.getSoil((class_1922)level, result.method_17777(), level.method_30349());
                if (soil.isPresent()) {
                    return Optional.of((MagnifyingInspectable)soil.get());
                }
            }
            return Optional.empty();
        });
        inspectors.add((level, player, hitResult) -> {
            class_243 lookAngle = player.method_5720();
            if (-0.1 <= lookAngle.field_1350 && lookAngle.field_1350 <= 0.1) {
                class_239 pick = class_310.method_1551().method_1560().method_5745(100.0, 0.0f, false);
                double sunOrientation = level.method_30274(0.0f);
                double playerOrientation = Math.atan2(lookAngle.field_1352, lookAngle.field_1351) / Math.PI / 2.0;
                if (-0.5 < playerOrientation && playerOrientation < 0.0) {
                    playerOrientation = Math.abs(playerOrientation);
                } else if (0.0 < playerOrientation && playerOrientation < 0.5) {
                    playerOrientation = 1.0 - playerOrientation;
                }
                double diff = sunOrientation - playerOrientation;
                if (-0.013 <= diff && diff <= 0.013 && pick.method_17783() == class_239.class_240.field_1333) {
                    return Optional.of((tooltip, isPlayerSneaking) -> tooltip.add(class_2561.method_43471((String)"agricraft.tooltip.magnifying.sun")));
                }
            }
            return Optional.empty();
        });
    }
}

